/*
  Leaderboard stats config for Bombing Run.
  
  Author Mark Caldwell aka W@rHe@d of The Reliquary
 */

/** The class that writes the BR general stats */

class UTLeaderboardWriteBR extends UTLeaderboardWriteTDM;

#linenumber 10

//Copies all relevant PRI game stats into the Properties struct of the OnlineStatsWrite
//There can be many more stats in the PRI than what is in the Properties table (on Xbox for example)
//If the Properties table does not contain the entry, the data is not written
function CopyAllStats(UTPlayerReplicationInfo PRI)
{
	Super.CopyAllStats(PRI);
}

defaultproperties
{ 
   StatNameToStatIdMapping(46)=(StatName="EVENT_HATTRICK",Id=268435553)
   
   //using flag events because orb events are not very usable for this.
   //see UTLeaderboardReadDM for events.
   
   //nothing exists for killed orb carrier
   StatNameToStatIdMapping(47)=(StatName="EVENT_KILLEDFLAGCARRIER",Id=268435554)
   
   //orb returns by itself so this is not a feat
   //StatNameToStatIdMapping(48)=(StatName="EVENT_RETURNEDFLAG",Id=268435555)
   
   StatNameToStatIdMapping(48)=(StatName="EVENT_SCOREDFLAG",Id=268435560)
   
   //called "Orbs Used" so not very good
   //StatNameToStatIdMapping(47)=(StatName="EVENT_SCOREDORB",Id=268435559)   
   
   Properties(46)=(PropertyId=268435553,Data=(Type=SDT_Int32))
   Properties(47)=(PropertyId=268435554,Data=(Type=SDT_Int32))
   Properties(48)=(PropertyId=268435560,Data=(Type=SDT_Int32))

   Name="Default__UTLeaderboardWriteBR"
   ObjectArchetype=UTLeaderboardWriteTDM'UTGame.Default__UTLeaderboardWriteTDM'
}
